function point(x,y)
  return {["x"]=x,["y"]=y}
end

ARROW = {[0]=point(0,-7),point(4,-3),point(1,-3),point(1,7),point(-1,7),point(-1,-3),point(-4,-3)} -- Arrow polygon
HOUSE = {[0]=point(0,-8),point(8,0),point(5,0),point(5,7),point(1,7),point(1,2),point(-1,2),point(-1,7),point(-5,7),point(-5,0),point(-8,0)} -- House polygon

function drawN(x,y,value, optsvalue ) 
  if value then 
     lcd.drawNumber(x, y,  value, optsvalue) 
   else  
     lcd.drawText(x, y,  "-", optsvalue) 
  end     
end;

function drawFldN(x,y,label, labelw, value, optslabel, optsvalue ) 
  if #label > 0 then
  lcd.drawText(x,y,  label, optslabel)
  end
  if value then 
     lcd.drawNumber(x+labelw, y,  value, optsvalue) 
   else  
     lcd.drawText(x+labelw, y,  "-", optsvalue) 
  end     
end;

function rotatePolygon(p,angle)
  angle = math.rad(angle)
  local s = math.sin(angle)
  local c = math.cos(angle)
  local a = {}  
  for i=0,#p,1 do
    local x = p[i].x * c - p[i].y * s;
    local y = p[i].x * s + p[i].y * c;
    a[i]=point(x,y)
  end
  return a
end

-- Resize polygon p, resize=1 unchanged, resize>1 multiply size
function resizePolygon(p,resize)
  local r = {}
  for i=0,#p,1 do
    r[i]=point(p[i].x * resize, p[i].y * resize)
  end
  return r
end

-- Draw polygon p at x,y resizing and color
function drawPolygon(p, x, y, resize)
  local flags = 0
  local l = #p + 1
  for i=0,l - 1,1 do
    local p1 = p[i]
    local p2 = p[(i+1) % l]    
    lcd.drawLine(x + p1.x*resize,y + p1.y*resize,x + p2.x*resize,y + p2.y*resize,SOLID,1,1)
  end
end

function drawArrow1(x,y,angle,size,color)
  local a = rotatePolygon(ARROW,angle)
  drawPolygon(a,x,y,size,color)
end


function footer() 
   --lcd.drawLine(0, 52, LCD_W, 52, SOLID,1,1)
   lcd.drawLine(0, 52, LCD_W, 52, SOLID,1,1)

  lcd.drawPixmap(1, 55, "/SCRIPTS/BMP/speed.bmp",1)
  lcd.drawText(31, 53,  string.format("%.1f",sensorSpd) ,MIDSIZE)
  
  
  --drawN(365,126,sensorSpd * 10, DBLSIZE+SHADOWED+YELLOW+PREC1) 
  
  lcd.drawPixmap(58, 55, "/SCRIPTS/BMP/DIST.bmp",1)
   
   
  if sensorDist then 
    lcd.drawNumber(93, 53, sensorDist  , MIDSIZE) else  lcd.drawText(93, 53,  "---",BLINK)
  end   
   
end

function header1() 
   lcd.drawPixmap(41, 0, "/SCRIPTS/BMP/vbat.bmp",1)
   lcd.drawNumber(55, 1,  ReceiverBatteryVoltage_current *10, PREC1)
   lcd.drawPixmap(75, 0, "/SCRIPTS/BMP/curr.bmp",1)
   lcd.drawNumber(88, 1,  sensorCurr *10, PREC1)
   
   lcd.drawPixmap(103, 1, "/SCRIPTS/BMP/sats.bmp")
   if re["sats"] then
    lcd.drawNumber(119, 1,  re["sats"])
   else 
    lcd.drawText(119, 1,  "-",BLINK)
   end
   --lcd.drawLine(0, 9, LCD_W, 9, SOLID,1,1)
   outMission(1,9,LCD_W-2,3) 
end

function drawRSSI(x, y, w, h)
   
    local rssi = getRSSI()
    if rssi and perc then
    if rssi > 38 then
        perc = round(perc * 0.5 + 0.5 * (((math.log(rssi - 28, 10) - 1) / (math.log(72, 10) - 1)) * 100))
	      if perc > 100 then perc = 100 end
    else
	      perc = 0
    end
    --lcd.drawText(x, y, perc .. '%', SMLSIZE + INVERS)
    --lcd.drawText(x, y+8, rssi .. 'dB', SMLSIZE + INVERS)
    lcd.drawFilledRectangle(x, y, w, h,SOLID)    
    lcd.drawFilledRectangle(x, y, w, h - perc/10 * h/10,WHITE)    
    lcd.drawRectangle(x, y, w, h, SOLID)    
    end
end

function drawboat(x,y,w,h,nbun) 
  local leftk = x + w/4
  local ycenter = y+h/2
    lcd.drawRectangle(x + w/4, y, w - w/4, h, 1)
    lcd.drawLine(x, ycenter, leftk, y+1, SOLID,1,1)
    lcd.drawLine(x, ycenter, leftk, y+h-1, SOLID,1,1)
    
   -- lcd.drawCircle(leftk,ycenter,12, BLACK)
    
end


function drawPixmap(x,y,img) 
  lcd.drawPixmap(x, y, img,1)
end

function drawField(x,y,img, value, opts) 
  drawPixmap(x, y, img)
  lcd.drawText(x+40, y, value, opts)
end

function outWP(x,y, wpnum,grpnum)
  drawPixmap(x, y, "/SCRIPTS/BMP/wp.bmp")
  if (wpnum) then
   lcd.drawText(x+22, y-1, wpnum, MIDSIZE)
  end
  
  if (grpnum) then
   lcd.drawText(x+12, y+3, grpnum.."/", SMLSIZE)
  end  
end

function outSpeed(x,y) 
  lcd.drawPixmap(x, y, "/SCRIPTS/BMP/speed.bmp",1)
  lcd.drawNumber(x+30, y-2,  sensorSpd * 10, PREC1+MIDSIZE)
end

function outDist(x,y,spd) 
  local v = sensorDist
  if (spd) then v = spd end
  lcd.drawPixmap(x, y, "/SCRIPTS/BMP/DIST.bmp",1)
  if v then 
    lcd.drawNumber(x+35, y-2, v  , MIDSIZE) else  lcd.drawText(93, 53,  "---",BLINK)
  end     
end

function outLoiter(x,y)
  drawPixmap(x, y,  "/SCRIPTS/BMP/loiter.bmp")
end

function outCRSC(x,y) 
    if re["crsc"] == 1 then 
     drawPixmap(x, y, "/SCRIPTS/BMP/crson.bmp",1)
    else 
     drawPixmap(x, y, "/SCRIPTS/BMP/crsoff.bmp",1)
    end     
end  

function outDeepBig(x,y) 
     lcd.drawPixmap(x, y, "/SCRIPTS/BMP/glubina.bmp",1)
     local aaa = 0
     if sensorAlt==0 then aaa=BLINK end
     lcd.drawNumber(x, y+10,  sensorAlt*10,PREC2+DBLSIZE+aaa)  
end

function outDeep(x,y) 
     lcd.drawPixmap(x, y, "/SCRIPTS/BMP/glubina.bmp",1)
     local aaa = 0
     if sensorAlt==0 then aaa=BLINK end
     lcd.drawNumber(x+41, y-2,  sensorAlt*10,PREC2+MIDSIZE+aaa)  
end

function outDeepSml(x,y) 
     lcd.drawText(x, y, "GL:",SMLSIZE)
     local aaa = 0
     if sensorAlt==0 then aaa=BLINK end
     lcd.drawNumber(x+12, y,  sensorAlt,PREC2+SMLSIZE+aaa)  
end

function outMission(x,y,w,h) 
  --re["miss"] =90
  if re["miss"] then
    lcd.drawGauge(x, y, w, h ,re["miss"], 100)
  else   
    --lcd.drawText(x, y,"HET",SMLSIZE)
     lcd.drawLine(x, y, w, y , SOLID,1,1)
     lcd.drawLine(x, y+h-1, w, y+h-1 , SOLID,1,1)
  end   
end

function outHeading(x,y,s) 
  local a = sensorHeading
  local angle =  360 - (a+180)
	if (angle < 0) then
		angle = angle + 360;
	end
	if (angle > 360) then
		angle = angle -360;
	end
  --angle=90
  drawArrow1(x,y,angle,s)  
  
end

function drawTXGPSDist(x,y,latitude, longitude, errvalue,opt) 
    if round(txlat)~=0 and round(txlon)~=0 and round(latitude)~=0 and round(longitude)~=0 then
        local ds = Haversine(txlat, txlon, latitude, longitude) * 1000
        lcd.drawText(x,y,string.format("%.1f",ds).."m", opt) 
        
    else    
        lcd.drawText(x,y,errvalue, opt) 
    end    
end



function drawRXBT(x, y, w, h)
  local v =  getValue("tx-voltage")
  local vv = v-5;
  local per = vv / (8.4 - 5) * 100
  --per = 81
  lcd.drawFilledRectangle(x, y, w, h,SOLID)    
  lcd.drawFilledRectangle(x, y, w, h - per/10 * h/10, BLACK)    
  lcd.drawRectangle(x, y, w, h, SOLID)    
end
  
local perc=0
function drawRSSI(x, y, w, h)
    local rssi = getRSSI()
    if rssi and perc then
      if rssi > 38 then
          perc = round(perc * 0.5 + 0.5 * (((math.log(rssi - 28, 10) - 1) / (math.log(72, 10) - 1)) * 100))
          if perc > 100 then perc = 100 end
      else
          perc = 0
      end
      --perc = 20
      --lcd.drawText(x, y, perc .. '%', MIDSIZE+SHADOWED+GREEN)
      --lcd.drawText(x, y+8, rssi .. 'dB', SMLSIZE + INVERS)
      
      lcd.drawFilledRectangle(x, y, w, h,SOLID)    
      lcd.drawFilledRectangle(x, y, w, h - perc/10 * h/10, BLACK)    
    end
   lcd.drawRectangle(x, y, w, h, SOLID)    

end  
  
  
function drawTXGPSInfo(x,y,opt) 
      lcd.drawText(x,y,"SATs:"..txsats.." hdop:"..string.format("%.2f",txhdop * 0.01),opt) 
end

function drawTXGPSDist(x,y,latitude, longitude, errvalue,opt) 
    if round(txlat)~=0 and round(txlon)~=0 and round(latitude)~=0 and round(longitude)~=0 then
        local ds = Haversine(txlat, txlon, latitude, longitude) * 1000
        lcd.drawText(x,y,string.format("%.1f",ds), opt) 
        
    else    
        lcd.drawText(x,y,errvalue, opt) 
    end    
end  


local function drawPathItem(x,y,id, p_wpnum, p_bunValue,selected, active)
    local wpnum = 0
    if p_wpnum then wpnum = p_wpnum end
    local bunValue = 0
    if p_bunValue then bunValue = p_bunValue end
    local bw=2
    local bh = 8
    local s=SMLSIZE
    local sa=SMLSIZE
    if selected then 
        s=s+INVERS+BLINK
      --lcd.drawFilledRectangle(x, y, 2, 8  , SMLSIZE) 
      --lcd.drawRectangle(x, y, (bw+5)*6+7, bh+1  , 1) 
    end
    
    if active then 
        sa=sa+BLINK
      --lcd.drawFilledRectangle(x, y, 2, 8  , SMLSIZE) 
      --lcd.drawRectangle(x, y, (bw+5)*6+7, bh+1  , 1) 
    end

    --lcd.drawRectangle(x, y, (bw+5)*6+5, bh+8  , csel) 
    lcd.drawText(x+1, y-8, id  , SMLSIZE) 
    lcd.drawNumber(x+7, y-8, wpnum  , s) 

    for i = 1, 6 do 
      local xx = x+i*8
      if bit32.extract( bunValue, i-1)==1 then
       lcd.drawText(xx+bw/2+9, y-8, i, INVERS+sa) 
      else  
       lcd.drawText(xx+bw/2+9, y-8, i, sa) 
      end
    end
end

function drawPathTable(x,y,n, selected, active) 
  local se=1
  if selected then se = selected end
  se = selected 
  local stpy = 8
  local cy = y
  for i = 1, n do 
    if selected == i then opt = INVERS end
    --drawPathItem(x,cy,i,re["pwp"..i], re["ptwp"..i.."b"], opt,se == i) 
    drawPathItem(x,cy,i,re["ptwp"..i], re["ptwp"..i.."b"], se == i, active and active == re["ptwp"..i]) 
    cy=cy+stpy
  end
end

function drawBunkerGa(x,y,h,w,name, val) 
  lcd.drawText(x, y, name  , SMLSIZE) 
  if val then
    lcd.drawGauge(x+10, y, w, h ,val, 10, SOLID)
  else
    lcd.drawRectangle(x+10, y, w, h, SOLID)    
  end
end

function drawBunker(x,y,h,w,name, v) 
  lcd.drawText(x, y, name  , SMLSIZE) 
  if not v then v=0 end
  local val = 10-v 
  lcd.drawRectangle(x+10, y, w , h, SOLID)    
  if val then
    local wws = w / 10 * val
    lcd.drawRectangle(x+10, y+1, wws , h-2, SOLID)    
    lcd.drawLine(x+10, y+h/2, x+9+wws , y+h/2, SOLID,1)    
  end
end

function drawBunkers(x,y,h,w,n,cnt) 
  local yy = y
  local mytable = { "B1", "B2", "B3", "B4","B5","B6" }
  for i,v in ipairs(mytable) do
     drawBunker(x,yy,h,w, v, re[v]) 
    --drawBunker(70,yy,6,30, v, 2) 
    yy=yy+8
  end    
end

function drawBunkersLS(x,y,buns,sizex,size, opt)
  for i = 1, maxbun do -- цикл от 1 до 8 с шагом 1
    local col = 0
    local s = buns[i]:state()
    if (s==1) then col = INVERS end
    if (s==2) then col = INVERS+BLINK end
    
    --lcd.drawFilledRectangle(x+i*sizex+2,y,sizex,sizey,SOLID+col)
    lcd.drawNumber(x+(i-1)*sizex+1,y,i, opt+col) 
  end    
end