local name = "LibGUI"
local libGUI

-- Return GUI library table
function loadGUI()
  if not libGUI then
  -- Loadable code chunk is called immediately and returns libGUI
  	libGUI = loadScript("/WIDGETS/" .. name .. "/libgui.lua")
  end
  
  return libGUI()
end



local TELE_PATH = "/SCRIPTS/UNIBOAT/TX16S/"
local v, r, m, i, e = getVersion()
if string.sub(r, -4) == "simu" then
   loadScript(TELE_PATH .. "uni", "bt")(zone, options)
end

-- Run once at the creation of the widget
local function create(zone, options)
   local uni = loadScript(TELE_PATH .. "uni","bt")(zone, options)
   --uni.background()
   --uni.init_func()
   return uni
end

local options = {
  { "BUNKERS", VALUE, 1, 1, 24 },
  { "NAVINRONIX", VALUE, 0, 1, 3 }
}


-- This function allow updates when you change widgets settings
local function update(widget, options)
   widget.update( options)
end

-- Called periodically when custom telemetry screen containing widget is visible.
local function refresh(widget, event, touchState)
   widget.refresh(event, touchState)
end

-- Called periodically when custom telemetry screen containing widget is not visible
local function background(widget)
  widget.background()
end

return {
  name = "uni",
  create = create,
  refresh = refresh,
  options = options,
  update = update,
  background = background
}
